using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.AHOBPR.BO;

namespace VIRP.AHOBPR.DAL
{
	public partial class REGISTRANT_SERVICE_EPISODEDB : VIRP.DBUtils
	{
		#region Fields
		#endregion

		#region Constructors

		public REGISTRANT_SERVICE_EPISODEDB()
		{
		}

		#endregion

		#region Properties
		#endregion

		#region Methods

		public REGISTRANT_SERVICE_EPISODE GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REGISTRANT_SERVICE_EPISODE_ID)
		{
			REGISTRANT_SERVICE_EPISODE objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_REGISTRANT_SERVICE_EPISODE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, REGISTRANT_SERVICE_EPISODE_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<REGISTRANT_SERVICE_EPISODE> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<REGISTRANT_SERVICE_EPISODE> objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_REGISTRANT_SERVICE_EPISODE_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, REGISTRANT_SERVICE_EPISODE objSave)
		{
			Int32? objReturn = objSave.REGISTRANT_SERVICE_EPISODE_ID;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_REGISTRANT_SERVICE_EPISODE_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.ACTIVATION_END_DATE, objSave.BRANCH_OF_SERVICE_TEXT, DateTime.Now, objSave.CREATEDBY, objSave.NARRATIVE_REASON_FOR_SEPARATION_TEXT, objSave.PERSONNEL_CATEGORY_TYPE_CODE, objSave.REGISTRANT_ID, ref objReturn, objSave.SERVICE_EPISODE_END_DATE, objSave.SERVICE_EPISODE_START_DATE, objSave.SERVICE_EPISODE_TERMINATION_REASON, objSave.STD_BRANCH_OF_SERVICE_ID, DateTime.Now, objSave.UPDATEDBY);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REGISTRANT_SERVICE_EPISODE_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_REGISTRANT_SERVICE_EPISODE_delete(CURRENT_USER, CURRENT_REGISTRY_ID, REGISTRANT_SERVICE_EPISODE_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
